//----------------------------------------------------------------------------
// Copyright 2021-2024 Joe Lowe
//
// Permission is granted to any person obtaining a copy of this Software,
// to deal in the Software without restriction, including the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and sell copies of
// the Software.
//
// The above copyright and permission notice must be left intact in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS WITHOUT WARRANTY.
//----------------------------------------------------------------------------
// file name:  fsres.h
// created:    2021.02.10
//----------------------------------------------------------------------------
#ifndef FSRES_H
#define FSRES_H
#include "ptpublic.h"
#include "ptmalloc.h"
#include "ptpin.h"
#include "ptreport.h"
PT_EXTERNC_START

enum {
   fsresFileTypeNone    = 0,
   fsresFileTypeFile    = 1,
   fsresFileTypeFolder  = 2,
   fsresFileTypeSymlink = 3,
   };
enum {
   fsresFileFlagReadOnly = 0x01,
   fsresFileFlagHidden   = 0x02,
   fsresFileFlagSystem   = 0x04,
   fsresFileFlagExecute  = 0x08,
   };

PT_TYPE_DEFINE( FsresAttribs)
{
   PT_INT8 fileType;
   PT_UINT8 fileFlags;
   PT_INT64 fileId;
   PT_UINT64 fileSize;
   PT_INT64 createTime;
   PT_INT64 writeTime;
   char* linkData;
};

PT_TYPE_DEFINE( FsresMediaInfo)
{
   PT_UUID mediaUuid;
   PT_UINT64 mediaId64;
   PT_INT64 createTime;
   PT_UINT64 totalCapacity;
   PT_SZ_T mediaLabel;
};

#define INTERFACE_NAME FsresList
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( void, Release);
   PT_INTERFACE_FUNC( void, List   , pin_i* cancelPin, bool/*ok*/ (*add)( void*, const FsresAttribs*, PT_SZC_T), void*);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME FsresFile
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( void               , Release  );
   PT_INTERFACE_FUN0( FsresList*         , ListStart);
   PT_INTERFACE_FUN0( const FsresAttribs*, Attribs  );
   PT_INTERFACE_FUNC( int/*err*/         , Read     , pin_i* cancelPin, PT_UINT64 fileOff, void* data, PT_SIZE_T requestedSize, PT_SIZE_T* outActualSize);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME FsresVolume
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( void                 , Retain   );
   PT_INTERFACE_FUN0( void                 , Release  );
   PT_INTERFACE_FUN0( const FsresMediaInfo*, MediaInfo);
   PT_INTERFACE_FUNC( int/*err*/           , Open     , malloc_i*, pin_i* cancelPin, PT_SZC_T* nameParts, PT_SIZE_T namePartCount, FsresFile** outFile, PT_INT64* outParentFileId, PT_SZC_T* outEndName, PT_SIZE_T* outLinkNamePartCount);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME FsresKeychain
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( const char*, NextPassword);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME FsresMedia
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( void      , Release     );
   PT_INTERFACE_FUNC( int/*err*/, Open        , FsresKeychain*);
   PT_INTERFACE_FUN0( uint64_t  , GetMediaSize);
   PT_INTERFACE_FUNC( int/*err*/, Read        , uint64_t off, void* buffer, size_t readSize);
   PT_INTERFACE_FUN0( void      , Flush       );
};
#undef INTERFACE_NAME

#define INTERFACE_NAME FsresFdCloser
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( void, Release);
   PT_INTERFACE_FUNC( void, CloseFd, FD_T, PT_SZC_T);
   PT_INTERFACE_FUN0( void, Drain  );
};
#undef INTERFACE_NAME

int/*err*/ CCALL FsresMediaMappedFactory( FsresMedia**, const void* data, size_t dataSize);
int/*err*/ CCALL FsresMediaFileFactory( FsresMedia**, PT_SZC_T mediaFileName);
int/*err*/ CCALL FsresMediaCisoMappedFactory( FsresMedia**, const void* data, size_t dataSize);
int/*err*/ CCALL FsresMediaCisoFileFactory( FsresMedia**, PT_SZC_T mediaFileName);
int/*err*/ CCALL FsresVolumeCfsFactory( FsresVolume**, FsresMedia** refMedia);
int/*err*/ CCALL FsresVolumeZipFactory( FsresVolume**, FsresMedia** refMedia);
FsresFdCloser* CCALL FsresFdCloserFactory( bool recall);
int/*err*/ CCALL FsresExtractVolume( pin_i* cancel_pin, pt_report_i*, FsresFdCloser*, FsresVolume*, szc_t destFolder);

PT_EXTERNC_END
#endif
