//----------------------------------------------------------------------------
// Copyright 1998-2024 Joe Lowe
//
// Permission is granted to any person obtaining a copy of this Software,
// to deal in the Software without restriction, including the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and sell copies of
// the Software.
//
// The above copyright and permission notice must be left intact in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS WITHOUT WARRANTY.
//----------------------------------------------------------------------------
// file name:  pfmformatter.h
// created:    2005.12.02
//----------------------------------------------------------------------------
#ifndef PFMFORMATTER_H
#define PFMFORMATTER_H
#include "ptmalloc.h"
#include "fsrenum.h"
PT_EXTERNC_START

typedef FsrAttribs PfmAttribs;

PT_TYPE_DEFINE( PfmOpenAttribs)
{
   PT_INT64 openId;
   PT_INT64 openSequence;
   PT_INT8 accessLevel;
   PT_UINT8 controlFlags;
   PT_UINT32 touch;
   PfmAttribs attribs;
};

PT_TYPE_DEFINE( PfmNamePart)
{
   const char* name;
   PT_SIZE_T len;
};

PT_TYPE_DEFINE( PfmMediaInfo)
{
   PT_UUID mediaUuid;
   PT_UINT64 mediaId64;
   PT_UINT32 mediaId32;
   PT_UINT8 mediaFlags;
   PT_INT64 createTime;
};

enum { pfmOpFormatterUseSize = 20*sizeof(int)+20*sizeof(void*) };

#define INTERFACE_NAME PfmFormatterSerializeOpen
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUNC( void, SerializeOpen, PT_INT64 openId, PT_INT64* openSequence);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerOpenOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( const PfmNamePart*, NameParts          );
   PT_INTERFACE_FUN0( PT_SIZE_T         , NamePartCount      );
   PT_INTERFACE_FUN0( PT_INT8           , CreateFileType     );
   PT_INTERFACE_FUN0( PT_UINT8          , CreateFileFlags    );
   PT_INTERFACE_FUN0( PT_INT64          , WriteTime          );
   PT_INTERFACE_FUN0( PT_INT64          , NewCreateOpenId    );
   PT_INTERFACE_FUN0( PT_INT8           , ExistingAccessLevel);
   PT_INTERFACE_FUN0( PT_INT64          , NewExistingOpenId  );
   PT_INTERFACE_FUNC( void              , Complete           , int perr, PT_UINT8/*bool*/ existed, const PfmOpenAttribs*, PT_INT64 parentFileId, const char* endName, PT_SIZE_T linkNamePartCount, const void* linkData, PT_SIZE_T linkDataSize, PfmFormatterSerializeOpen*);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerReplaceOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64          , TargetOpenId      );                                                                                                                                                                                                                                                               
   PT_INTERFACE_FUN0( PT_INT64          , TargetParentFileId);
   PT_INTERFACE_FUN0( const PfmNamePart*, TargetEndName     );
   PT_INTERFACE_FUN0( PT_UINT8          , CreateFileFlags   );
   PT_INTERFACE_FUN0( PT_INT64          , WriteTime         );
   PT_INTERFACE_FUN0( PT_INT64          , NewCreateOpenId   );
   PT_INTERFACE_FUNC( void              , Complete          , int perr, const PfmOpenAttribs*, PfmFormatterSerializeOpen*);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerMoveOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64          , SourceOpenId       );
   PT_INTERFACE_FUN0( PT_INT64          , SourceParentFileId );
   PT_INTERFACE_FUN0( const PfmNamePart*, SourceEndName      );
   PT_INTERFACE_FUN0( const PfmNamePart*, TargetNameParts    );
   PT_INTERFACE_FUN0( PT_SIZE_T         , TargetNamePartCount);
   PT_INTERFACE_FUN0( PT_UINT8/*bool*/  , DeleteSource       );
   PT_INTERFACE_FUN0( PT_INT64          , WriteTime          );
   PT_INTERFACE_FUN0( PT_INT8           , ExistingAccessLevel);
   PT_INTERFACE_FUN0( PT_INT64          , NewExistingOpenId  );
   PT_INTERFACE_FUNC( void              , Complete           , int perr, PT_UINT8/*bool*/ existed, const PfmOpenAttribs*, PT_INT64 parentFileId, const char* endName, PT_SIZE_T linkNamePartCount, const void* linkData, PT_SIZE_T linkDataSize, PfmFormatterSerializeOpen*);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerMoveReplaceOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64          , SourceOpenId      );
   PT_INTERFACE_FUN0( PT_INT64          , SourceParentFileId);
   PT_INTERFACE_FUN0( const PfmNamePart*, SourceEndName     );
   PT_INTERFACE_FUN0( PT_INT64          , TargetOpenId      );
   PT_INTERFACE_FUN0( PT_INT64          , TargetParentFileId);
   PT_INTERFACE_FUN0( const PfmNamePart*, TargetEndName     );
   PT_INTERFACE_FUN0( PT_UINT8/*bool*/  , DeleteSource      );
   PT_INTERFACE_FUN0( PT_INT64          , WriteTime         );
   PT_INTERFACE_FUNC( void              , Complete          , int perr);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerDeleteOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64          , OpenId      );
   PT_INTERFACE_FUN0( PT_INT64          , ParentFileId);
   PT_INTERFACE_FUN0( const PfmNamePart*, EndName     );
   PT_INTERFACE_FUN0( PT_INT64          , WriteTime   );
   PT_INTERFACE_FUNC( void              , Complete    , int perr);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerCloseOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64, OpenId      );
   PT_INTERFACE_FUN0( PT_INT64, OpenSequence);
   PT_INTERFACE_FUNC( void    , Complete    , int perr);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerFlushFileOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64   , OpenId      );
   PT_INTERFACE_FUN0( PT_UINT8   , FlushFlags  );
   PT_INTERFACE_FUN0( PT_UINT8   , FileFlags   );
   PT_INTERFACE_FUN0( PT_UINT8   , Color       );
   PT_INTERFACE_FUN0( PT_INT64   , CreateTime  );
   PT_INTERFACE_FUN0( PT_INT64   , AccessTime  );
   PT_INTERFACE_FUN0( PT_INT64   , WriteTime   );
   PT_INTERFACE_FUN0( PT_INT64   , ChangeTime  );
   PT_INTERFACE_FUN0( const void*, LinkData    );
   PT_INTERFACE_FUN0( PT_UINT32  , LinkDataSize);
   PT_INTERFACE_FUNC( void       , Complete    , int perr, const PfmOpenAttribs*, PfmFormatterSerializeOpen*);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerListOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64        , OpenId  );
   PT_INTERFACE_FUN0( PT_INT64        , ListId  );
   PT_INTERFACE_FUNC( PT_UINT8/*bool*/, Add     , const PfmAttribs*, const char* endName);
   PT_INTERFACE_FUNC( void            , Complete, int perr, PT_UINT8/*bool*/ noMore);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerListEndOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64, OpenId  );
   PT_INTERFACE_FUN0( PT_INT64, ListId  );
   PT_INTERFACE_FUNC( void    , Complete, int perr);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerReadOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64 , OpenId       );
   PT_INTERFACE_FUN0( PT_UINT64, FileOffset   );
   PT_INTERFACE_FUN0( void*    , Data         );
   PT_INTERFACE_FUN0( PT_SIZE_T, RequestedSize);
   PT_INTERFACE_FUNC( void     , Complete     , int perr, PT_SIZE_T actualSize);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerWriteOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64   , OpenId       );
   PT_INTERFACE_FUN0( PT_UINT64  , FileOffset   );
   PT_INTERFACE_FUN0( const void*, Data         );
   PT_INTERFACE_FUN0( PT_SIZE_T  , RequestedSize);
   PT_INTERFACE_FUNC( void       , Complete     , int perr, PT_SIZE_T actualSize);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerSetSizeOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64 , OpenId  );
   PT_INTERFACE_FUN0( PT_UINT64, FileSize);
   PT_INTERFACE_FUNC( void     , Complete, int perr);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerCapacityOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64, OpenId  );
   PT_INTERFACE_FUNC( void    , Complete, int perr, PT_UINT64 totalCapacity, PT_UINT64 availableCapacity);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerFlushMediaOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUNC( void, Complete, int perr, int msecFlushDelay);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerControlOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64   , OpenId       );
   PT_INTERFACE_FUN0( PT_INT8    , AccessLevel  );
   PT_INTERFACE_FUN0( int        , ControlCode  );
   PT_INTERFACE_FUN0( const void*, Input        );
   PT_INTERFACE_FUN0( PT_SIZE_T  , InputSize    );
   PT_INTERFACE_FUN0( void*      , Output       );
   PT_INTERFACE_FUN0( PT_SIZE_T  , MaxOutputSize);
   PT_INTERFACE_FUNC( void       , Complete     , int perr, PT_SIZE_T outputSize);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerMediaInfoOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64, OpenId  );
   PT_INTERFACE_FUNC( void    , Complete, int perr, PfmMediaInfo const* mediaInfo, const char* mediaLabel);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerAccessOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64, OpenId     );
   PT_INTERFACE_FUN0( PT_INT8 , AccessLevel);
   PT_INTERFACE_FUNC( void    , Complete   , int perr, const PfmOpenAttribs*, PfmFormatterSerializeOpen*);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerReadXattrOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64          , OpenId       );
   PT_INTERFACE_FUN0( const PfmNamePart*, Name         );
   PT_INTERFACE_FUN0( PT_UINT32         , Offset       );
   PT_INTERFACE_FUN0( void*             , Data         );
   PT_INTERFACE_FUN0( PT_SIZE_T         , RequestedSize);
   PT_INTERFACE_FUNC( void              , Complete     , int perr, PT_UINT32 xattrSize, PT_SIZE_T transferredSize);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmMarshallerWriteXattrOp
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUN0( PT_INT64          , OpenId       );
   PT_INTERFACE_FUN0( const PfmNamePart*, Name         );
   PT_INTERFACE_FUN0( PT_UINT32         , XattrSize    );
   PT_INTERFACE_FUN0( PT_UINT32         , Offset       );
   PT_INTERFACE_FUN0( const void*       , Data         );
   PT_INTERFACE_FUN0( PT_SIZE_T          , RequestedSize);
   PT_INTERFACE_FUNC( void              , Complete     , int perr, PT_SIZE_T transferredSize);
};
#undef INTERFACE_NAME

#define INTERFACE_NAME PfmFormatterDispatch
PT_INTERFACE_DEFINE
{
   PT_INTERFACE_FUNC( void, Open       , PfmMarshallerOpenOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Replace    , PfmMarshallerReplaceOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Move       , PfmMarshallerMoveOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, MoveReplace, PfmMarshallerMoveReplaceOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Delete     , PfmMarshallerDeleteOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Close      , PfmMarshallerCloseOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, FlushFile  , PfmMarshallerFlushFileOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, List       , PfmMarshallerListOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, ListEnd    , PfmMarshallerListEndOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Read       , PfmMarshallerReadOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Write      , PfmMarshallerWriteOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, SetSize    , PfmMarshallerSetSizeOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Capacity   , PfmMarshallerCapacityOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, FlushMedia , PfmMarshallerFlushMediaOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Control    , PfmMarshallerControlOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, MediaInfo  , PfmMarshallerMediaInfoOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, Access     , PfmMarshallerAccessOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, ReadXattr  , PfmMarshallerReadXattrOp*, void* formatterUse);
   PT_INTERFACE_FUNC( void, WriteXattr , PfmMarshallerWriteXattrOp*, void* formatterUse);
};
#undef INTERFACE_NAME

PT_EXTERNC_END
#endif
