//----------------------------------------------------------------------------
// Pismo Technic Inc. Copyright 2003-2024 Joe Lowe
//
// Permission is granted to any person obtaining a copy of this Software,
// to deal in the Software without restriction, including the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and sell copies of
// the Software.
//
// The above copyright and permission notice must be left intact in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS WITHOUT WARRANTY.
//----------------------------------------------------------------------------
// file name:  fsrapi.hxx
// created:    2005.12.02
//----------------------------------------------------------------------------
#ifndef FSRAPI_HXX
#define FSRAPI_HXX
#include "ptmalloc.h"
#include "ptpin.h"
#ifdef FSRAPI_RUNTIME_LINK
#include "ptdlfcn.h"
#endif
#include "fsrenum.hxx"
#ifdef __cplusplus_cli
#pragma managed(push,off)
#endif
extern "C" {
PT_C_ASSERT_STRUCT_PACKING(FSRAPI_HXX);


struct FsrMountCreateParams
{
   int mountFlags;
   int timeout;
   pin_i* cancelPin;
   PT_FD_T transport;
   PT_FD_T watchdog;
   PT_SZC_T mountSourceName;
   PT_SZC_T ownerId;
   PT_SZC_T appId;
   PT_SZC_T transportSecurity;
   PT_SZC_T mountPoint;
   PT_SZC_T driveLetter;
   PT_SZC_T cacheStorageHandle;
   PT_SZC_T cacheVolumeId;
   PT_SZC_T cacheSecret;
   PT_UINT64 ramCacheSize;

   FsrMountCreateParams()
      { memset( this, 0, sizeof( *this));
      mountFlags = fsrMountFlagCacheNameSpace | fsrMountFlagUnmountOnDisconnect;
      watchdog = transport = PT_FD_INVALID;
      timeout = -1; }
};

struct FsrMountInfo
{
   int mountId;
   int mountFlags;
   int statusFlags;
   int volumeFlags;
   char driveLetter;
   PT_SZ_T controlDevName;
   PT_SZ_T mountSourceName;
   PT_SZ_T mountPoint;
   PT_SZ_T uncName;
   PT_SZ_T ownerId;
   PT_SZ_T formatterName;
   PT_SZ_T mountEndName;
   PT_SZ_T appId;
   PT_UINT64 cacheSize;
};

struct FsrCacheFileInfo
{
   PT_INT64 fileId;
   PT_INT64 createTime;
   PT_INT64 writeTime;
   PT_UINT64 fileSize;
};

struct/*interface*/ FsrClient;
struct/*interface*/ FsrServer;
struct/*interface*/ FsrFormatter;
struct/*interface*/ FsrFlowMonitor;
struct/*interface*/ PfmFormatterDispatch;
struct/*interface*/ pt_transport2_i;
struct/*interface*/ xway_client_i;
struct/*interface*/ xway_server_i;
struct/*interface*/ FsrPolicyFormatterOwner;
struct/*interface*/ FsresVolume;
static const unsigned fsrResTouchMapSize = 0x1000;

#ifdef FSRAPI_STATIC_LINK

int /*err*/ PT_CCALL FsrSysStart( pin_i* cancelPin);
int /*err*/ PT_CCALL FsrMountCreate( PT_FD_T* fd, pin_i* cancelPin, const FsrMountCreateParams* mcp);
int /*err*/ PT_CCALL FsrMountUnmount( PT_FD_T fd, pin_i* cancelPin, int unmountFlags);
int /*err*/ PT_CCALL FsrMountFlush( PT_FD_T fd);
int /*err*/ PT_CCALL FsrMountControl( PT_FD_T fd, PT_UINT8 scope, PT_SZC_T interfaceId, int controlCode, const void* input, PT_SIZE_T inputSize, void* output, PT_SIZE_T maxOutputSize, PT_SIZE_T* outputSize);
int /*err*/ PT_CCALL FsrMountGetInfo( malloc_i* ma, FsrMountInfo** mi, PT_FD_T fd);
pin_i* PT_CCALL FsrRetainMountListChangePin( pin_i* cancelPin);
void PT_CCALL FsrReleaseMountListChangePin( pin_i* pin);
PT_SIZE_T PT_CCALL FsrMountGetList( malloc_i* ma, FsrMountInfo*** mi, unsigned* driveLetterMask, PT_SZC_T appId);
int /*err*/ PT_CCALL FsrMountOpenByInfo( PT_FD_T* fd, const FsrMountInfo* mi);
int /*err*/ PT_CCALL FsrMountOpenByFile( PT_FD_T* fd, PT_SZC_T file);
int /*err*/ PT_CCALL FsrMountOpenByMountPoint( PT_FD_T* fd, PT_SZC_T mountPoint);
int /*err*/ PT_CCALL FsrMountGetInfoByFile( malloc_i* ma, FsrMountInfo** mi, PT_SZC_T file);
int /*err*/ PT_CCALL FsrMountGetInfoByMountPoint( malloc_i* ma, FsrMountInfo** mi, PT_SZC_T mountPoint);
int /*err*/ PT_CCALL FsrCreateDriveLetterLink( char driveLetter, PT_SZC_T target);
void PT_CCALL FsrDeleteDriveLetterLink( char driveLetter);
int /*perr*/ PT_CCALL FsrConvertErrToPerr( int err);
int /*err*/ PT_CCALL FsrSystemCreatePipe( PT_FD_T* readFd, PT_FD_T* writeFd);
int /*err*/ PT_CCALL FsrSystemCreateSocket( PT_FD_T* fd1, PT_FD_T* fd2);
void PT_CCALL FsrSystemCloseFd( PT_FD_T fd);
int /*err*/ PT_CCALL FsrServerFactory( FsrServer** server, PT_FD_T transport, PT_SZC_T transportSecurity, PT_FD_T status, PT_SZC_T traceChannelName, PT_SZC_T formatterName, int volumeFlags);
int /*err*/ PT_CCALL FsrCacheLoad( malloc_i* ma, pin_i* cancelPin, PT_SZ_T* message, PT_SZ_T* handle, PT_FD_T* controlFd, PT_FD_T storageFd, PT_UINT64 storageOff, PT_UINT64 storageSize);
int /*err*/ PT_CCALL FsrCacheUnload( PT_FD_T fd);
int /*err*/ PT_CCALL FsrCachePoll( PT_FD_T fd);
int /*err*/ PT_CCALL FsrCacheGetFileStatus( PT_FD_T fd, PT_SIZE_T fileCount, const FsrCacheFileInfo* fileTable, PT_UINT64* statusTable);
PT_SZ_T /*data*/ PT_CCALL FsrReport( malloc_i* ma);
PT_SZ_T /*data*/ PT_CCALL FsrMountReport( malloc_i* ma, PT_FD_T fd);
int /*err*/ PT_CCALL FsrClientFactory( FsrClient** client, PT_SZC_T traceName, int clientFlags, int clientFileNameType, pt_transport2_i** transport, PT_SZC_T transportSecurity);
int /*err*/ PT_CCALL FsrFormatterResFactory( FsresVolume** volume, pin_i* cancelPin, FsrFormatter** formatter);
int /*err*/ PT_CCALL FsrResFormatterFactory( FsrFormatter** formatter, FsresVolume* volume);
int /*err*/ PT_CCALL FsrShimFormatterFactory( FsrFormatter** formatter, PfmFormatterDispatch* dispatch);
int /*err*/ PT_CCALL FsrReadOnlyFormatterFactory( FsrFormatter** formatter);
int /*err*/ PT_CCALL FsrFixNamesFormatterFactory( FsrFormatter** formatter, int serverFileNameType, int clientFileNameType);
int /*err*/ PT_CCALL FsrLogFormatterFactory( FsrFormatter** formatter, PT_SZC_T logName);
int /*err*/ PT_CCALL FsrPolicyFormatterFactory( FsrFormatter** formatter, FsrPolicyFormatterOwner* owner);
int /*err*/ PT_CCALL FsrCacheFormatterFactory( FsrFormatter** formatter, PT_SZC_T traceName, PT_SZC_T cacheHandle, PT_SZC_T volumeId, PT_SZC_T secret);
int /*err*/ PT_CCALL FsrRedirFormatterFactory( FsrFormatter** formatter, PT_SZC_T root_folder, int concurrency);
int /*err*/ PT_CCALL FsrXwayClientFactory( xway_client_i** xway, pin_i* cancelPin);
int /*err*/ PT_CCALL FsrXwayServerFactory( xway_server_i** xway, pin_i* cancelPin);
int /*err*/ PT_CCALL FsrCreateCompositeSocket( PT_FD_T* fd, pin_i* cancelPin, PT_SIZE_T chunkSize, PT_SIZE_T memberCount, const PT_FD_T* memberTable);

#endif
#ifdef FSRAPI_RUNTIME_LINK

static int fsrapi_loader_initialized = 0;
static void* fsrapi_loader_module = 0;
static union { void* v; int /*err*/ (PT_CCALL*f)( pin_i* cancelPin); } FsrSysStart_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T* fd, pin_i* cancelPin, const FsrMountCreateParams* mcp); } FsrMountCreate_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T fd, pin_i* cancelPin, int unmountFlags); } FsrMountUnmount_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T fd); } FsrMountFlush_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T fd, PT_UINT8 scope, PT_SZC_T interfaceId, int controlCode, const void* input, PT_SIZE_T inputSize, void* output, PT_SIZE_T maxOutputSize, PT_SIZE_T* outputSize); } FsrMountControl_;
static union { void* v; int /*err*/ (PT_CCALL*f)( malloc_i* ma, FsrMountInfo** mi, PT_FD_T fd); } FsrMountGetInfo_;
static union { void* v; pin_i* (PT_CCALL*f)( pin_i* cancelPin); } FsrRetainMountListChangePin_;
static union { void* v; void (PT_CCALL*f)( pin_i* pin); } FsrReleaseMountListChangePin_;
static union { void* v; PT_SIZE_T (PT_CCALL*f)( malloc_i* ma, FsrMountInfo*** mi, unsigned* driveLetterMask, PT_SZC_T appId); } FsrMountGetList_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T* fd, const FsrMountInfo* mi); } FsrMountOpenByInfo_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T* fd, PT_SZC_T file); } FsrMountOpenByFile_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T* fd, PT_SZC_T mountPoint); } FsrMountOpenByMountPoint_;
static union { void* v; int /*err*/ (PT_CCALL*f)( malloc_i* ma, FsrMountInfo** mi, PT_SZC_T file); } FsrMountGetInfoByFile_;
static union { void* v; int /*err*/ (PT_CCALL*f)( malloc_i* ma, FsrMountInfo** mi, PT_SZC_T mountPoint); } FsrMountGetInfoByMountPoint_;
static union { void* v; int /*err*/ (PT_CCALL*f)( char driveLetter, PT_SZC_T target); } FsrCreateDriveLetterLink_;
static union { void* v; void (PT_CCALL*f)( char driveLetter); } FsrDeleteDriveLetterLink_;
static union { void* v; int /*perr*/ (PT_CCALL*f)( int err); } FsrConvertErrToPerr_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T* readFd, PT_FD_T* writeFd); } FsrSystemCreatePipe_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T* fd1, PT_FD_T* fd2); } FsrSystemCreateSocket_;
static union { void* v; void (PT_CCALL*f)( PT_FD_T fd); } FsrSystemCloseFd_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrServer** server, PT_FD_T transport, PT_SZC_T transportSecurity, PT_FD_T status, PT_SZC_T traceChannelName, PT_SZC_T formatterName, int volumeFlags); } FsrServerFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( malloc_i* ma, pin_i* cancelPin, PT_SZ_T* message, PT_SZ_T* handle, PT_FD_T* controlFd, PT_FD_T storageFd, PT_UINT64 storageOff, PT_UINT64 storageSize); } FsrCacheLoad_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T fd); } FsrCacheUnload_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T fd); } FsrCachePoll_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T fd, PT_SIZE_T fileCount, const FsrCacheFileInfo* fileTable, PT_UINT64* statusTable); } FsrCacheGetFileStatus_;
static union { void* v; PT_SZ_T /*data*/ (PT_CCALL*f)( malloc_i* ma); } FsrReport_;
static union { void* v; PT_SZ_T /*data*/ (PT_CCALL*f)( malloc_i* ma, PT_FD_T fd); } FsrMountReport_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrClient** client, PT_SZC_T traceName, int clientFlags, int clientFileNameType, pt_transport2_i** transport, PT_SZC_T transportSecurity); } FsrClientFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsresVolume** volume, pin_i* cancelPin, FsrFormatter** formatter); } FsrFormatterResFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrFormatter** formatter, FsresVolume* volume); } FsrResFormatterFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrFormatter** formatter, PfmFormatterDispatch* dispatch); } FsrShimFormatterFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrFormatter** formatter); } FsrReadOnlyFormatterFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrFormatter** formatter, int serverFileNameType, int clientFileNameType); } FsrFixNamesFormatterFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrFormatter** formatter, PT_SZC_T logName); } FsrLogFormatterFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrFormatter** formatter, FsrPolicyFormatterOwner* owner); } FsrPolicyFormatterFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrFormatter** formatter, PT_SZC_T traceName, PT_SZC_T cacheHandle, PT_SZC_T volumeId, PT_SZC_T secret); } FsrCacheFormatterFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( FsrFormatter** formatter, PT_SZC_T root_folder, int concurrency); } FsrRedirFormatterFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( xway_client_i** xway, pin_i* cancelPin); } FsrXwayClientFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( xway_server_i** xway, pin_i* cancelPin); } FsrXwayServerFactory_;
static union { void* v; int /*err*/ (PT_CCALL*f)( PT_FD_T* fd, pin_i* cancelPin, PT_SIZE_T chunkSize, PT_SIZE_T memberCount, const PT_FD_T* memberTable); } FsrCreateCompositeSocket_;
PT_NOINLINE static void* fsrapi_dlsym( const char* name) { return fsrapi_loader_module ? pt_dlsym( fsrapi_loader_module, name) : (void*)0; }
static void PT_CCALL fsrapi_loader_terminator( void)
{
   if (fsrapi_loader_module) pt_dlclose( fsrapi_loader_module);
   fsrapi_loader_module = 0;
}
PT_NOINLINE static void fsrapi_loader_initializer( void)
{
   if (fsrapi_loader_initialized) return;
   fsrapi_loader_initialized = 1;
   fsrapi_loader_module = pt_dlopen( PT_QUOTE( FSRAPI_RUNTIME_LINK) "." PT_PLUGINEXTA);
   atexit( fsrapi_loader_terminator);
   FsrSysStart_.v = fsrapi_dlsym( "FsrSysStart");
   FsrMountCreate_.v = fsrapi_dlsym( "FsrMountCreate");
   FsrMountUnmount_.v = fsrapi_dlsym( "FsrMountUnmount");
   FsrMountFlush_.v = fsrapi_dlsym( "FsrMountFlush");
   FsrMountControl_.v = fsrapi_dlsym( "FsrMountControl");
   FsrMountGetInfo_.v = fsrapi_dlsym( "FsrMountGetInfo");
   FsrRetainMountListChangePin_.v = fsrapi_dlsym( "FsrRetainMountListChangePin");
   FsrReleaseMountListChangePin_.v = fsrapi_dlsym( "FsrReleaseMountListChangePin");
   FsrMountGetList_.v = fsrapi_dlsym( "FsrMountGetList");
   FsrMountOpenByInfo_.v = fsrapi_dlsym( "FsrMountOpenByInfo");
   FsrMountOpenByFile_.v = fsrapi_dlsym( "FsrMountOpenByFile");
   FsrMountOpenByMountPoint_.v = fsrapi_dlsym( "FsrMountOpenByMountPoint");
   FsrMountGetInfoByFile_.v = fsrapi_dlsym( "FsrMountGetInfoByFile");
   FsrMountGetInfoByMountPoint_.v = fsrapi_dlsym( "FsrMountGetInfoByMountPoint");
   FsrCreateDriveLetterLink_.v = fsrapi_dlsym( "FsrCreateDriveLetterLink");
   FsrDeleteDriveLetterLink_.v = fsrapi_dlsym( "FsrDeleteDriveLetterLink");
   FsrConvertErrToPerr_.v = fsrapi_dlsym( "FsrConvertErrToPerr");
   FsrSystemCreatePipe_.v = fsrapi_dlsym( "FsrSystemCreatePipe");
   FsrSystemCreateSocket_.v = fsrapi_dlsym( "FsrSystemCreateSocket");
   FsrSystemCloseFd_.v = fsrapi_dlsym( "FsrSystemCloseFd");
   FsrServerFactory_.v = fsrapi_dlsym( "FsrServerFactory");
   FsrCacheLoad_.v = fsrapi_dlsym( "FsrCacheLoad");
   FsrCacheUnload_.v = fsrapi_dlsym( "FsrCacheUnload");
   FsrCachePoll_.v = fsrapi_dlsym( "FsrCachePoll");
   FsrCacheGetFileStatus_.v = fsrapi_dlsym( "FsrCacheGetFileStatus");
   FsrReport_.v = fsrapi_dlsym( "FsrReport");
   FsrMountReport_.v = fsrapi_dlsym( "FsrMountReport");
   FsrClientFactory_.v = fsrapi_dlsym( "FsrClientFactory");
   FsrFormatterResFactory_.v = fsrapi_dlsym( "FsrFormatterResFactory");
   FsrResFormatterFactory_.v = fsrapi_dlsym( "FsrResFormatterFactory");
   FsrShimFormatterFactory_.v = fsrapi_dlsym( "FsrShimFormatterFactory");
   FsrReadOnlyFormatterFactory_.v = fsrapi_dlsym( "FsrReadOnlyFormatterFactory");
   FsrFixNamesFormatterFactory_.v = fsrapi_dlsym( "FsrFixNamesFormatterFactory");
   FsrLogFormatterFactory_.v = fsrapi_dlsym( "FsrLogFormatterFactory");
   FsrPolicyFormatterFactory_.v = fsrapi_dlsym( "FsrPolicyFormatterFactory");
   FsrCacheFormatterFactory_.v = fsrapi_dlsym( "FsrCacheFormatterFactory");
   FsrRedirFormatterFactory_.v = fsrapi_dlsym( "FsrRedirFormatterFactory");
   FsrXwayClientFactory_.v = fsrapi_dlsym( "FsrXwayClientFactory");
   FsrXwayServerFactory_.v = fsrapi_dlsym( "FsrXwayServerFactory");
   FsrCreateCompositeSocket_.v = fsrapi_dlsym( "FsrCreateCompositeSocket");
}
PT_INLINE void fsrapi_auto_load( void) { if (!fsrapi_loader_initialized) fsrapi_loader_initializer(); }

PT_INLINE2 int/*bool ok*/ FsrApiLoad( void) { fsrapi_loader_initializer(); return !!fsrapi_loader_module; }
PT_INLINE2 void FsrApiUnload( void) { fsrapi_loader_terminator(); }

PT_INLINE int /*err*/ FsrSysStart( pin_i* cancelPin) { fsrapi_auto_load(); return FsrSysStart_.f( cancelPin); }
PT_INLINE int /*err*/ FsrMountCreate( PT_FD_T* fd, pin_i* cancelPin, const FsrMountCreateParams* mcp) { fsrapi_auto_load(); return FsrMountCreate_.f( fd, cancelPin, mcp); }
PT_INLINE int /*err*/ FsrMountUnmount( PT_FD_T fd, pin_i* cancelPin, int unmountFlags) { fsrapi_auto_load(); return FsrMountUnmount_.f( fd, cancelPin, unmountFlags); }
PT_INLINE int /*err*/ FsrMountFlush( PT_FD_T fd) { fsrapi_auto_load(); return FsrMountFlush_.f( fd); }
PT_INLINE int /*err*/ FsrMountControl( PT_FD_T fd, PT_UINT8 scope, PT_SZC_T interfaceId, int controlCode, const void* input, PT_SIZE_T inputSize, void* output, PT_SIZE_T maxOutputSize, PT_SIZE_T* outputSize) { fsrapi_auto_load(); return FsrMountControl_.f( fd, scope, interfaceId, controlCode, input, inputSize, output, maxOutputSize, outputSize); }
PT_INLINE int /*err*/ FsrMountGetInfo( malloc_i* ma, FsrMountInfo** mi, PT_FD_T fd) { fsrapi_auto_load(); return FsrMountGetInfo_.f( ma, mi, fd); }
PT_INLINE pin_i* FsrRetainMountListChangePin( pin_i* cancelPin) { fsrapi_auto_load(); return FsrRetainMountListChangePin_.f( cancelPin); }
PT_INLINE void FsrReleaseMountListChangePin( pin_i* pin) { fsrapi_auto_load(); FsrReleaseMountListChangePin_.f( pin); }
PT_INLINE PT_SIZE_T FsrMountGetList( malloc_i* ma, FsrMountInfo*** mi, unsigned* driveLetterMask, PT_SZC_T appId) { fsrapi_auto_load(); return FsrMountGetList_.f( ma, mi, driveLetterMask, appId); }
PT_INLINE int /*err*/ FsrMountOpenByInfo( PT_FD_T* fd, const FsrMountInfo* mi) { fsrapi_auto_load(); return FsrMountOpenByInfo_.f( fd, mi); }
PT_INLINE int /*err*/ FsrMountOpenByFile( PT_FD_T* fd, PT_SZC_T file) { fsrapi_auto_load(); return FsrMountOpenByFile_.f( fd, file); }
PT_INLINE int /*err*/ FsrMountOpenByMountPoint( PT_FD_T* fd, PT_SZC_T mountPoint) { fsrapi_auto_load(); return FsrMountOpenByMountPoint_.f( fd, mountPoint); }
PT_INLINE int /*err*/ FsrMountGetInfoByFile( malloc_i* ma, FsrMountInfo** mi, PT_SZC_T file) { fsrapi_auto_load(); return FsrMountGetInfoByFile_.f( ma, mi, file); }
PT_INLINE int /*err*/ FsrMountGetInfoByMountPoint( malloc_i* ma, FsrMountInfo** mi, PT_SZC_T mountPoint) { fsrapi_auto_load(); return FsrMountGetInfoByMountPoint_.f( ma, mi, mountPoint); }
PT_INLINE int /*err*/ FsrCreateDriveLetterLink( char driveLetter, PT_SZC_T target) { fsrapi_auto_load(); return FsrCreateDriveLetterLink_.f( driveLetter, target); }
PT_INLINE void FsrDeleteDriveLetterLink( char driveLetter) { fsrapi_auto_load(); FsrDeleteDriveLetterLink_.f( driveLetter); }
PT_INLINE int /*perr*/ FsrConvertErrToPerr( int err) { fsrapi_auto_load(); return FsrConvertErrToPerr_.f( err); }
PT_INLINE int /*err*/ FsrSystemCreatePipe( PT_FD_T* readFd, PT_FD_T* writeFd) { fsrapi_auto_load(); return FsrSystemCreatePipe_.f( readFd, writeFd); }
PT_INLINE int /*err*/ FsrSystemCreateSocket( PT_FD_T* fd1, PT_FD_T* fd2) { fsrapi_auto_load(); return FsrSystemCreateSocket_.f( fd1, fd2); }
PT_INLINE void FsrSystemCloseFd( PT_FD_T fd) { fsrapi_auto_load(); FsrSystemCloseFd_.f( fd); }
PT_INLINE int /*err*/ FsrServerFactory( FsrServer** server, PT_FD_T transport, PT_SZC_T transportSecurity, PT_FD_T status, PT_SZC_T traceChannelName, PT_SZC_T formatterName, int volumeFlags) { fsrapi_auto_load(); return FsrServerFactory_.f( server, transport, transportSecurity, status, traceChannelName, formatterName, volumeFlags); }
PT_INLINE int /*err*/ FsrCacheLoad( malloc_i* ma, pin_i* cancelPin, PT_SZ_T* message, PT_SZ_T* handle, PT_FD_T* controlFd, PT_FD_T storageFd, PT_UINT64 storageOff, PT_UINT64 storageSize) { fsrapi_auto_load(); return FsrCacheLoad_.f( ma, cancelPin, message, handle, controlFd, storageFd, storageOff, storageSize); }
PT_INLINE int /*err*/ FsrCacheUnload( PT_FD_T fd) { fsrapi_auto_load(); return FsrCacheUnload_.f( fd); }
PT_INLINE int /*err*/ FsrCachePoll( PT_FD_T fd) { fsrapi_auto_load(); return FsrCachePoll_.f( fd); }
PT_INLINE int /*err*/ FsrCacheGetFileStatus( PT_FD_T fd, PT_SIZE_T fileCount, const FsrCacheFileInfo* fileTable, PT_UINT64* statusTable) { fsrapi_auto_load(); return FsrCacheGetFileStatus_.f( fd, fileCount, fileTable, statusTable); }
PT_INLINE PT_SZ_T /*data*/ FsrReport( malloc_i* ma) { fsrapi_auto_load(); return FsrReport_.f( ma); }
PT_INLINE PT_SZ_T /*data*/ FsrMountReport( malloc_i* ma, PT_FD_T fd) { fsrapi_auto_load(); return FsrMountReport_.f( ma, fd); }
PT_INLINE int /*err*/ FsrClientFactory( FsrClient** client, PT_SZC_T traceName, int clientFlags, int clientFileNameType, pt_transport2_i** transport, PT_SZC_T transportSecurity) { fsrapi_auto_load(); return FsrClientFactory_.f( client, traceName, clientFlags, clientFileNameType, transport, transportSecurity); }
PT_INLINE int /*err*/ FsrFormatterResFactory( FsresVolume** volume, pin_i* cancelPin, FsrFormatter** formatter) { fsrapi_auto_load(); return FsrFormatterResFactory_.f( volume, cancelPin, formatter); }
PT_INLINE int /*err*/ FsrResFormatterFactory( FsrFormatter** formatter, FsresVolume* volume) { fsrapi_auto_load(); return FsrResFormatterFactory_.f( formatter, volume); }
PT_INLINE int /*err*/ FsrShimFormatterFactory( FsrFormatter** formatter, PfmFormatterDispatch* dispatch) { fsrapi_auto_load(); return FsrShimFormatterFactory_.f( formatter, dispatch); }
PT_INLINE int /*err*/ FsrReadOnlyFormatterFactory( FsrFormatter** formatter) { fsrapi_auto_load(); return FsrReadOnlyFormatterFactory_.f( formatter); }
PT_INLINE int /*err*/ FsrFixNamesFormatterFactory( FsrFormatter** formatter, int serverFileNameType, int clientFileNameType) { fsrapi_auto_load(); return FsrFixNamesFormatterFactory_.f( formatter, serverFileNameType, clientFileNameType); }
PT_INLINE int /*err*/ FsrLogFormatterFactory( FsrFormatter** formatter, PT_SZC_T logName) { fsrapi_auto_load(); return FsrLogFormatterFactory_.f( formatter, logName); }
PT_INLINE int /*err*/ FsrPolicyFormatterFactory( FsrFormatter** formatter, FsrPolicyFormatterOwner* owner) { fsrapi_auto_load(); return FsrPolicyFormatterFactory_.f( formatter, owner); }
PT_INLINE int /*err*/ FsrCacheFormatterFactory( FsrFormatter** formatter, PT_SZC_T traceName, PT_SZC_T cacheHandle, PT_SZC_T volumeId, PT_SZC_T secret) { fsrapi_auto_load(); return FsrCacheFormatterFactory_.f( formatter, traceName, cacheHandle, volumeId, secret); }
PT_INLINE int /*err*/ FsrRedirFormatterFactory( FsrFormatter** formatter, PT_SZC_T root_folder, int concurrency) { fsrapi_auto_load(); return FsrRedirFormatterFactory_.f( formatter, root_folder, concurrency); }
PT_INLINE int /*err*/ FsrXwayClientFactory( xway_client_i** xway, pin_i* cancelPin) { fsrapi_auto_load(); return FsrXwayClientFactory_.f( xway, cancelPin); }
PT_INLINE int /*err*/ FsrXwayServerFactory( xway_server_i** xway, pin_i* cancelPin) { fsrapi_auto_load(); return FsrXwayServerFactory_.f( xway, cancelPin); }
PT_INLINE int /*err*/ FsrCreateCompositeSocket( PT_FD_T* fd, pin_i* cancelPin, PT_SIZE_T chunkSize, PT_SIZE_T memberCount, const PT_FD_T* memberTable) { fsrapi_auto_load(); return FsrCreateCompositeSocket_.f( fd, cancelPin, chunkSize, memberCount, memberTable); }

#endif

}
#ifdef __cplusplus_cli
#pragma managed(pop)
#endif
#endif
