//----------------------------------------------------------------------------
// Pismo Technic Inc. Copyright 2003-2024 Joe Lowe
//
// Permission is granted to any person obtaining a copy of this Software,
// to deal in the Software without restriction, including the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and sell copies of
// the Software.
//
// The above copyright and permission notice must be left intact in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS WITHOUT WARRANTY.
//----------------------------------------------------------------------------
// file name:  fsrenum.h
// created:    2005.12.02
//----------------------------------------------------------------------------
#ifndef FSRENUM_H
#define FSRENUM_H
#ifdef __cplusplus
#include "fsrenum.hxx"
#else
#include "ptpublic.h"

enum {
   fsrMountFlagReadOnly = 0x00000001,
   fsrMountFlagWorldRead = 0x00000004,
   fsrMountFlagWorldWrite = 0x00000008,
   fsrMountFlagUncOnly = 0x00000010,
   fsrMountFlagVerbose = 0x00000020,
   fsrMountFlagWaitReady = 0x00000040,
   fsrMountFlagForceUnbuffered = 0x00000080,
   fsrMountFlagForceBuffered = 0x00000100,
   fsrMountFlagGroupRead = 0x00000400,
   fsrMountFlagGroupWrite = 0x00000800,
   fsrMountFlagGroupOwned = 0x00001000,
   fsrMountFlagWorldOwned = 0x00002000,
   fsrMountFlagCacheNameSpace = 0x00004000,
   fsrMountFlagBrowse = 0x00010000,
   fsrMountFlagUnmountOnRelease = 0x00020000,
   fsrMountFlagUnmountOnDisconnect = 0x00040000,
   fsrMountFlagLocalDriveType = 0x00080000,
   fsrMountFlagAccelerate = 0x00200000,
   fsrMountFlagForceDriveLetter = 0x00400000,
   fsrMountFlagAvidCompat = 0x00800000,
};

enum {
   fsrUnmountFlagBackground = 0x0001,
};

enum {
   fsrStatusFlagInitializing = 0x0001,
   fsrStatusFlagReady = 0x0002,
   fsrStatusFlagDisconnected = 0x0004,
   fsrStatusFlagClosed = 0x0008,
};

enum {
   fsrVolumeFlagReadOnly = 0x0001,
   fsrVolumeFlagCompressed = 0x0002,
   fsrVolumeFlagEncrypted = 0x0004,
   fsrVolumeFlagCaseSensitive = 0x0008,
   fsrVolumeFlagTouchMap = 0x0010,
   fsrVolumeFlagNoCreateTime = 0x0100,
   fsrVolumeFlagNoAccessTime = 0x0200,
   fsrVolumeFlagNoWriteTime = 0x0400,
   fsrVolumeFlagNoChangeTime = 0x0800,
   fsrVolumeFlagXattr = 0x1000,
   fsrVolumeFlagSymlinks = 0x2000,
   fsrVolumeFlagFakeNamedStreams = 0x4000,
   fsrVolumeFlagAccelerate = 0x8000,
};

enum {
   fsrErrorSuccess = 0,
   fsrErrorDisconnect = 1,
   fsrErrorCancelled = 2,
   fsrErrorUnsupported = 3,
   fsrErrorInvalid = 4,
   fsrErrorAccessDenied = 5,
   fsrErrorOutOfMemory = 6,
   fsrErrorFailed = 7,
   fsrErrorNotFound = 8,
   fsrErrorParentNotFound = 9,
   fsrErrorExists = 10,
   fsrErrorNoSpace = 11,
   fsrErrorBadName = 12,
   fsrErrorNotEmpty = 13,
   fsrErrorEndOfData = 14,
   fsrErrorNotAFile = 15,
   fsrErrorDeleted = 16,
   fsrErrorCorruptData = 17,
   fsrErrorTimeout = 18,
   fsrErrorNotAFolder = 19,
   fsrErrorWrongVolume = 24,
};

enum {
   fsrFileTypeNone = 0,
   fsrFileTypeFile = 1,
   fsrFileTypeFolder = 2,
   fsrFileTypeSymlink = 3,
};
enum { fsrFileFlagsInvalid = 0xFF };

enum {
   fsrFileFlagReadOnly = 0x01,
   fsrFileFlagHidden = 0x02,
   fsrFileFlagSystem = 0x04,
   fsrFileFlagExecute = 0x08,
   fsrFileFlagHasIcon = 0x10,
   fsrFileFlagArchive = 0x20,
   fsrFileFlagAlias = 0x40,
};

enum {
   fsrExtraFlagOffline = 0x01,
   fsrExtraFlagReserved1 = 0x02,
   fsrExtraFlagNtfsCompressed = 0x04,
   fsrExtraFlagNtfsEncrypted = 0x08,
};

enum {
   fsrColorInvalid = 0,
   fsrColorDefault = 1,
   fsrColorGray = 2,
   fsrColorGreen = 3,
   fsrColorPurple = 4,
   fsrColorBlue = 5,
   fsrColorYellow = 6,
   fsrColorRed = 7,
   fsrColorOrange = 8,
};

enum {
   fsrTimeInvalid = 0,
};

enum {
   fsrAccessLevelLookup = 0,
   fsrAccessLevelReadInfo = 1,
   fsrAccessLevelReadData = 2,
   fsrAccessLevelWriteInfo = 3,
   fsrAccessLevelDelete = 4,
   fsrAccessLevelWriteData = 5,
   fsrAccessLevelOwner = 6,
};

enum {
   fsrControlFlagForceUnbuffered = 1,
   fsrControlFlagForceBuffered = 2,
   fsrControlFlagSlowAppends = 4,
};

enum {
   fsrClientFlagXattr = 0x0001,
   fsrClientFlagAccelerate = 0x0002,
};

enum {
   fsrFileNameTypeAny = 0x00,
   fsrFileNameTypeWindows = 0x01,
   fsrFileNameTypeUnix = 0x02,
   fsrFileNameTypeMac = 0x03,
};

enum {
   fsrFlushFlagOpen = 0x0001,
};

enum {
   fsrControlScopeLocal = 0x00,
   fsrControlScopeRemote = 0x01,
};

typedef struct FsrAttribs FsrAttribs; struct FsrAttribs
{
   PT_INT8 fileType;
   PT_UINT8 fileFlags;
   PT_UINT8 extraFlags;
   PT_UINT8 color;
   PT_UINT32 resourceSize;
   PT_INT64 fileId;
   PT_UINT64 fileSize;
   PT_INT64 createTime;
   PT_INT64 accessTime;
   PT_INT64 writeTime;
   PT_INT64 changeTime;
};

#endif
#endif
