//----------------------------------------------------------------------------
// Pismo Technic Inc. Copyright 2003-2024 Joe Lowe
//
// Permission is granted to any person obtaining a copy of this Software,
// to deal in the Software without restriction, including the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and sell copies of
// the Software.
//
// The above copyright and permission notice must be left intact in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS WITHOUT WARRANTY.
//----------------------------------------------------------------------------
// file name:  fsrapi.hxx
// created:    2005.12.02
//----------------------------------------------------------------------------
#ifndef FSRENUM_HXX
#define FSRENUM_HXX
#include "ptpublic.h"
#ifdef __cplusplus_cli
#pragma managed(push,off)
#endif
extern "C" {

static const int fsrMountFlagReadOnly = 0x00000001;
static const int fsrMountFlagWorldRead = 0x00000004;
static const int fsrMountFlagWorldWrite = 0x00000008;
static const int fsrMountFlagUncOnly = 0x00000010;
static const int fsrMountFlagVerbose = 0x00000020;
static const int fsrMountFlagWaitReady = 0x00000040;
static const int fsrMountFlagForceUnbuffered = 0x00000080;
static const int fsrMountFlagForceBuffered = 0x00000100;
static const int fsrMountFlagGroupRead = 0x00000400;
static const int fsrMountFlagGroupWrite = 0x00000800;
static const int fsrMountFlagGroupOwned = 0x00001000;
static const int fsrMountFlagWorldOwned = 0x00002000;
static const int fsrMountFlagCacheNameSpace = 0x00004000;
static const int fsrMountFlagBrowse = 0x00010000;
static const int fsrMountFlagUnmountOnRelease = 0x00020000;
static const int fsrMountFlagUnmountOnDisconnect = 0x00040000;
static const int fsrMountFlagLocalDriveType = 0x00080000;
static const int fsrMountFlagAccelerate = 0x00200000;
static const int fsrMountFlagForceDriveLetter = 0x00400000;
static const int fsrMountFlagAvidCompat = 0x00800000;

static const int fsrUnmountFlagBackground = 0x0001;

static const int fsrStatusFlagInitializing = 0x0001;
static const int fsrStatusFlagReady = 0x0002;
static const int fsrStatusFlagDisconnected = 0x0004;
static const int fsrStatusFlagClosed = 0x0008;

static const int fsrVolumeFlagReadOnly = 0x0001;
static const int fsrVolumeFlagCompressed = 0x0002;
static const int fsrVolumeFlagEncrypted = 0x0004;
static const int fsrVolumeFlagCaseSensitive = 0x0008;
static const int fsrVolumeFlagTouchMap = 0x0010;
static const int fsrVolumeFlagNoCreateTime = 0x0100;
static const int fsrVolumeFlagNoAccessTime = 0x0200;
static const int fsrVolumeFlagNoWriteTime = 0x0400;
static const int fsrVolumeFlagNoChangeTime = 0x0800;
static const int fsrVolumeFlagXattr = 0x1000;
static const int fsrVolumeFlagSymlinks = 0x2000;
static const int fsrVolumeFlagFakeNamedStreams = 0x4000;
static const int fsrVolumeFlagAccelerate = 0x8000;

static const int fsrErrorSuccess = 0;
static const int fsrErrorDisconnect = 1;
static const int fsrErrorCancelled = 2;
static const int fsrErrorUnsupported = 3;
static const int fsrErrorInvalid = 4;
static const int fsrErrorAccessDenied = 5;
static const int fsrErrorOutOfMemory = 6;
static const int fsrErrorFailed = 7;
static const int fsrErrorNotFound = 8;
static const int fsrErrorParentNotFound = 9;
static const int fsrErrorExists = 10;
static const int fsrErrorNoSpace = 11;
static const int fsrErrorBadName = 12;
static const int fsrErrorNotEmpty = 13;
static const int fsrErrorEndOfData = 14;
static const int fsrErrorNotAFile = 15;
static const int fsrErrorDeleted = 16;
static const int fsrErrorCorruptData = 17;
static const int fsrErrorTimeout = 18;
static const int fsrErrorNotAFolder = 19;
static const int fsrErrorWrongVolume = 24;

static const PT_INT8 fsrFileTypeNone = 0;
static const PT_INT8 fsrFileTypeFile = 1;
static const PT_INT8 fsrFileTypeFolder = 2;
static const PT_INT8 fsrFileTypeSymlink = 3;
static const PT_UINT8 fsrFileFlagsInvalid = 0xFF;

static const PT_UINT8 fsrFileFlagReadOnly = 0x01;
static const PT_UINT8 fsrFileFlagHidden = 0x02;
static const PT_UINT8 fsrFileFlagSystem = 0x04;
static const PT_UINT8 fsrFileFlagExecute = 0x08;
static const PT_UINT8 fsrFileFlagHasIcon = 0x10;
static const PT_UINT8 fsrFileFlagArchive = 0x20;
static const PT_UINT8 fsrFileFlagAlias = 0x40;

static const PT_UINT8 fsrExtraFlagOffline = 0x01;
static const PT_UINT8 fsrExtraFlagReserved1 = 0x02;
static const PT_UINT8 fsrExtraFlagNtfsCompressed = 0x04;
static const PT_UINT8 fsrExtraFlagNtfsEncrypted = 0x08;

static const PT_UINT8 fsrColorInvalid = 0;
static const PT_UINT8 fsrColorDefault = 1;
static const PT_UINT8 fsrColorGray = 2;
static const PT_UINT8 fsrColorGreen = 3;
static const PT_UINT8 fsrColorPurple = 4;
static const PT_UINT8 fsrColorBlue = 5;
static const PT_UINT8 fsrColorYellow = 6;
static const PT_UINT8 fsrColorRed = 7;
static const PT_UINT8 fsrColorOrange = 8;

static const PT_INT64 fsrTimeInvalid = 0;

static const PT_INT8 fsrAccessLevelLookup = 0;
static const PT_INT8 fsrAccessLevelReadInfo = 1;
static const PT_INT8 fsrAccessLevelReadData = 2;
static const PT_INT8 fsrAccessLevelWriteInfo = 3;
static const PT_INT8 fsrAccessLevelDelete = 4;
static const PT_INT8 fsrAccessLevelWriteData = 5;
static const PT_INT8 fsrAccessLevelOwner = 6;

static const PT_UINT8 fsrControlFlagForceUnbuffered = 1;
static const PT_UINT8 fsrControlFlagForceBuffered = 2;
static const PT_UINT8 fsrControlFlagSlowAppends = 4;

static const int fsrClientFlagXattr = 0x0001;
static const int fsrClientFlagAccelerate = 0x0002;

static const PT_INT8 fsrFileNameTypeAny = 0x00;
static const PT_INT8 fsrFileNameTypeWindows = 0x01;
static const PT_INT8 fsrFileNameTypeUnix = 0x02;
static const PT_INT8 fsrFileNameTypeMac = 0x03;

static const int fsrFlushFlagOpen = 0x0001;

static const PT_UINT8 fsrControlScopeLocal = 0x00;
static const PT_UINT8 fsrControlScopeRemote = 0x01;

struct FsrAttribs
{
   PT_INT8 fileType;
   PT_UINT8 fileFlags;
   PT_UINT8 extraFlags;
   PT_UINT8 color;
   PT_UINT32 resourceSize;
   PT_INT64 fileId;
   PT_UINT64 fileSize;
   PT_INT64 createTime;
   PT_INT64 accessTime;
   PT_INT64 writeTime;
   PT_INT64 changeTime;
};

}
#ifdef __cplusplus_cli
#pragma managed(pop)
#endif
#endif
